<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Monitoring;

class GetNotificationChannelVerificationCodeResponse extends \Google\Model
{
  /**
   * The verification code, which may be used to verify other channels that have
   * an equivalent identity (i.e. other channels of the same type with the same
   * fingerprint such as other email channels with the same email address or
   * other sms channels with the same number).
   *
   * @var string
   */
  public $code;
  /**
   * The expiration time associated with the code that was returned. If an
   * expiration was provided in the request, this is the minimum of the
   * requested expiration in the request and the max permitted expiration.
   *
   * @var string
   */
  public $expireTime;

  /**
   * The verification code, which may be used to verify other channels that have
   * an equivalent identity (i.e. other channels of the same type with the same
   * fingerprint such as other email channels with the same email address or
   * other sms channels with the same number).
   *
   * @param string $code
   */
  public function setCode($code)
  {
    $this->code = $code;
  }
  /**
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }
  /**
   * The expiration time associated with the code that was returned. If an
   * expiration was provided in the request, this is the minimum of the
   * requested expiration in the request and the max permitted expiration.
   *
   * @param string $expireTime
   */
  public function setExpireTime($expireTime)
  {
    $this->expireTime = $expireTime;
  }
  /**
   * @return string
   */
  public function getExpireTime()
  {
    return $this->expireTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GetNotificationChannelVerificationCodeResponse::class, 'Google_Service_Monitoring_GetNotificationChannelVerificationCodeResponse');
