<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\FirebaseAppDistribution;

class GoogleFirebaseAppdistroV1BatchJoinGroupRequest extends \Google\Collection
{
  protected $collection_key = 'emails';
  /**
   * Indicates whether to create tester resources based on `emails` if they
   * don't exist yet.
   *
   * @var bool
   */
  public $createMissingTesters;
  /**
   * Required. The emails of the testers to be added to the group. A maximum of
   * 999 and a minimum of 1 tester can be created in a batch.
   *
   * @var string[]
   */
  public $emails;

  /**
   * Indicates whether to create tester resources based on `emails` if they
   * don't exist yet.
   *
   * @param bool $createMissingTesters
   */
  public function setCreateMissingTesters($createMissingTesters)
  {
    $this->createMissingTesters = $createMissingTesters;
  }
  /**
   * @return bool
   */
  public function getCreateMissingTesters()
  {
    return $this->createMissingTesters;
  }
  /**
   * Required. The emails of the testers to be added to the group. A maximum of
   * 999 and a minimum of 1 tester can be created in a batch.
   *
   * @param string[] $emails
   */
  public function setEmails($emails)
  {
    $this->emails = $emails;
  }
  /**
   * @return string[]
   */
  public function getEmails()
  {
    return $this->emails;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleFirebaseAppdistroV1BatchJoinGroupRequest::class, 'Google_Service_FirebaseAppDistribution_GoogleFirebaseAppdistroV1BatchJoinGroupRequest');
