<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DisplayVideo;

class InventorySourceAssignedTargetingOptionDetails extends \Google\Model
{
  /**
   * Required. ID of the inventory source. Should refer to the
   * inventory_source_id field of an InventorySource resource.
   *
   * @var string
   */
  public $inventorySourceId;

  /**
   * Required. ID of the inventory source. Should refer to the
   * inventory_source_id field of an InventorySource resource.
   *
   * @param string $inventorySourceId
   */
  public function setInventorySourceId($inventorySourceId)
  {
    $this->inventorySourceId = $inventorySourceId;
  }
  /**
   * @return string
   */
  public function getInventorySourceId()
  {
    return $this->inventorySourceId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InventorySourceAssignedTargetingOptionDetails::class, 'Google_Service_DisplayVideo_InventorySourceAssignedTargetingOptionDetails');
