<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudIdentity;

class GoogleAppsCloudidentityDevicesV1ListDevicesResponse extends \Google\Collection
{
  protected $collection_key = 'devices';
  protected $devicesType = GoogleAppsCloudidentityDevicesV1Device::class;
  protected $devicesDataType = 'array';
  /**
   * Token to retrieve the next page of results. Empty if there are no more
   * results.
   *
   * @var string
   */
  public $nextPageToken;

  /**
   * Devices meeting the list restrictions.
   *
   * @param GoogleAppsCloudidentityDevicesV1Device[] $devices
   */
  public function setDevices($devices)
  {
    $this->devices = $devices;
  }
  /**
   * @return GoogleAppsCloudidentityDevicesV1Device[]
   */
  public function getDevices()
  {
    return $this->devices;
  }
  /**
   * Token to retrieve the next page of results. Empty if there are no more
   * results.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleAppsCloudidentityDevicesV1ListDevicesResponse::class, 'Google_Service_CloudIdentity_GoogleAppsCloudidentityDevicesV1ListDevicesResponse');
