<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\BigQueryDataTransfer;

class ListTransferRunsResponse extends \Google\Collection
{
  protected $collection_key = 'transferRuns';
  /**
   * Output only. The next-pagination token. For multiple-page list results,
   * this token can be used as the `ListTransferRunsRequest.page_token` to
   * request the next page of list results.
   *
   * @var string
   */
  public $nextPageToken;
  protected $transferRunsType = TransferRun::class;
  protected $transferRunsDataType = 'array';

  /**
   * Output only. The next-pagination token. For multiple-page list results,
   * this token can be used as the `ListTransferRunsRequest.page_token` to
   * request the next page of list results.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * Output only. The stored pipeline transfer runs.
   *
   * @param TransferRun[] $transferRuns
   */
  public function setTransferRuns($transferRuns)
  {
    $this->transferRuns = $transferRuns;
  }
  /**
   * @return TransferRun[]
   */
  public function getTransferRuns()
  {
    return $this->transferRuns;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ListTransferRunsResponse::class, 'Google_Service_BigQueryDataTransfer_ListTransferRunsResponse');
