<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Apigee;

class GoogleCloudApigeeV1ApiProxyRevision extends \Google\Collection
{
  protected $collection_key = 'teams';
  /**
   * Output only. The archive that generated this proxy revision. This field is
   * only present on proxy revisions that were generated by an archive. Proxies
   * generated by archives cannot be updated, deleted, or deployed to other
   * environments. Format: `organizations/environments/archiveDeployments`
   *
   * @var string
   */
  public $archive;
  /**
   * Base URL of the API proxy.
   *
   * @var string[]
   */
  public $basepaths;
  protected $configurationVersionType = GoogleCloudApigeeV1ConfigVersion::class;
  protected $configurationVersionDataType = '';
  /**
   * Revision number, app name, and organization for the API proxy.
   *
   * @var string
   */
  public $contextInfo;
  /**
   * Time that the API proxy revision was created in milliseconds since epoch.
   *
   * @var string
   */
  public $createdAt;
  /**
   * Description of the API proxy revision.
   *
   * @var string
   */
  public $description;
  /**
   * Human-readable name of the API proxy.
   *
   * @var string
   */
  public $displayName;
  /**
   * Metadata describing the API proxy revision as a key-value map.
   *
   * @var string[]
   */
  public $entityMetaDataAsProperties;
  /**
   * Output only. This field will be marked as true if revision contains any
   * policies marked as extensible.
   *
   * @var bool
   */
  public $hasExtensiblePolicy;
  /**
   * List of IntegrationEndpoints in the '/integration-endpoints' directory of
   * the API proxy. This is a 'manifest' setting designed to provide visibility
   * into the contents of the API proxy.
   *
   * @var string[]
   */
  public $integrationEndpoints;
  /**
   * Time that the API proxy revision was last modified in milliseconds since
   * epoch.
   *
   * @var string
   */
  public $lastModifiedAt;
  /**
   * Name of the API proxy.
   *
   * @var string
   */
  public $name;
  /**
   * List of policy names included in the API proxy revision..
   *
   * @var string[]
   */
  public $policies;
  /**
   * List of proxy names included in the API proxy revision.
   *
   * @var string[]
   */
  public $proxies;
  /**
   * List of ProxyEndpoints in the `/proxies` directory of the API proxy.
   * Typically, this element is included only when the API proxy was created
   * using the Edge UI. This is a 'manifest' setting designed to provide
   * visibility into the contents of the API proxy.
   *
   * @var string[]
   */
  public $proxyEndpoints;
  protected $resourceFilesType = GoogleCloudApigeeV1ResourceFiles::class;
  protected $resourceFilesDataType = '';
  /**
   * List of the resources included in the API proxy revision formatted as
   * "{type}://{name}".
   *
   * @var string[]
   */
  public $resources;
  /**
   * API proxy revision.
   *
   * @var string
   */
  public $revision;
  /**
   * List of the shared flows included in the API proxy revision.
   *
   * @var string[]
   */
  public $sharedFlows;
  /**
   * OpenAPI Specification that is associated with the API proxy. The value is
   * set to a URL or to a path in the specification store.
   *
   * @var string
   */
  public $spec;
  /**
   * List of TargetEndpoints in the `/targets` directory of the API proxy.
   * Typically, this element is included only when the API proxy was created
   * using the Edge UI. This is a 'manifest' setting designed to provide
   * visibility into the contents of the API proxy.
   *
   * @var string[]
   */
  public $targetEndpoints;
  /**
   * List of TargetServers referenced in any TargetEndpoint in the API proxy.
   * Typically, you will see this element only when the API proxy was created
   * using the Edge UI. This is a 'manifest' setting designed to provide
   * visibility into the contents of the API proxy.
   *
   * @var string[]
   */
  public $targetServers;
  /**
   * List of the targets included in the API proxy revision.
   *
   * @var string[]
   */
  public $targets;
  /**
   * List of the teams included in the API proxy revision.
   *
   * @var string[]
   */
  public $teams;
  /**
   * Type. Set to `Application`. Maintained for compatibility with the Apigee
   * Edge API.
   *
   * @var string
   */
  public $type;

  /**
   * Output only. The archive that generated this proxy revision. This field is
   * only present on proxy revisions that were generated by an archive. Proxies
   * generated by archives cannot be updated, deleted, or deployed to other
   * environments. Format: `organizations/environments/archiveDeployments`
   *
   * @param string $archive
   */
  public function setArchive($archive)
  {
    $this->archive = $archive;
  }
  /**
   * @return string
   */
  public function getArchive()
  {
    return $this->archive;
  }
  /**
   * Base URL of the API proxy.
   *
   * @param string[] $basepaths
   */
  public function setBasepaths($basepaths)
  {
    $this->basepaths = $basepaths;
  }
  /**
   * @return string[]
   */
  public function getBasepaths()
  {
    return $this->basepaths;
  }
  /**
   * Version of the API proxy configuration schema to which the API proxy
   * conforms. Currently, the only supported value is 4.0
   * (`majorVersion.minorVersion`). This setting may be used in the future to
   * track the evolution of the API proxy format.
   *
   * @param GoogleCloudApigeeV1ConfigVersion $configurationVersion
   */
  public function setConfigurationVersion(GoogleCloudApigeeV1ConfigVersion $configurationVersion)
  {
    $this->configurationVersion = $configurationVersion;
  }
  /**
   * @return GoogleCloudApigeeV1ConfigVersion
   */
  public function getConfigurationVersion()
  {
    return $this->configurationVersion;
  }
  /**
   * Revision number, app name, and organization for the API proxy.
   *
   * @param string $contextInfo
   */
  public function setContextInfo($contextInfo)
  {
    $this->contextInfo = $contextInfo;
  }
  /**
   * @return string
   */
  public function getContextInfo()
  {
    return $this->contextInfo;
  }
  /**
   * Time that the API proxy revision was created in milliseconds since epoch.
   *
   * @param string $createdAt
   */
  public function setCreatedAt($createdAt)
  {
    $this->createdAt = $createdAt;
  }
  /**
   * @return string
   */
  public function getCreatedAt()
  {
    return $this->createdAt;
  }
  /**
   * Description of the API proxy revision.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Human-readable name of the API proxy.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Metadata describing the API proxy revision as a key-value map.
   *
   * @param string[] $entityMetaDataAsProperties
   */
  public function setEntityMetaDataAsProperties($entityMetaDataAsProperties)
  {
    $this->entityMetaDataAsProperties = $entityMetaDataAsProperties;
  }
  /**
   * @return string[]
   */
  public function getEntityMetaDataAsProperties()
  {
    return $this->entityMetaDataAsProperties;
  }
  /**
   * Output only. This field will be marked as true if revision contains any
   * policies marked as extensible.
   *
   * @param bool $hasExtensiblePolicy
   */
  public function setHasExtensiblePolicy($hasExtensiblePolicy)
  {
    $this->hasExtensiblePolicy = $hasExtensiblePolicy;
  }
  /**
   * @return bool
   */
  public function getHasExtensiblePolicy()
  {
    return $this->hasExtensiblePolicy;
  }
  /**
   * List of IntegrationEndpoints in the '/integration-endpoints' directory of
   * the API proxy. This is a 'manifest' setting designed to provide visibility
   * into the contents of the API proxy.
   *
   * @param string[] $integrationEndpoints
   */
  public function setIntegrationEndpoints($integrationEndpoints)
  {
    $this->integrationEndpoints = $integrationEndpoints;
  }
  /**
   * @return string[]
   */
  public function getIntegrationEndpoints()
  {
    return $this->integrationEndpoints;
  }
  /**
   * Time that the API proxy revision was last modified in milliseconds since
   * epoch.
   *
   * @param string $lastModifiedAt
   */
  public function setLastModifiedAt($lastModifiedAt)
  {
    $this->lastModifiedAt = $lastModifiedAt;
  }
  /**
   * @return string
   */
  public function getLastModifiedAt()
  {
    return $this->lastModifiedAt;
  }
  /**
   * Name of the API proxy.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * List of policy names included in the API proxy revision..
   *
   * @param string[] $policies
   */
  public function setPolicies($policies)
  {
    $this->policies = $policies;
  }
  /**
   * @return string[]
   */
  public function getPolicies()
  {
    return $this->policies;
  }
  /**
   * List of proxy names included in the API proxy revision.
   *
   * @param string[] $proxies
   */
  public function setProxies($proxies)
  {
    $this->proxies = $proxies;
  }
  /**
   * @return string[]
   */
  public function getProxies()
  {
    return $this->proxies;
  }
  /**
   * List of ProxyEndpoints in the `/proxies` directory of the API proxy.
   * Typically, this element is included only when the API proxy was created
   * using the Edge UI. This is a 'manifest' setting designed to provide
   * visibility into the contents of the API proxy.
   *
   * @param string[] $proxyEndpoints
   */
  public function setProxyEndpoints($proxyEndpoints)
  {
    $this->proxyEndpoints = $proxyEndpoints;
  }
  /**
   * @return string[]
   */
  public function getProxyEndpoints()
  {
    return $this->proxyEndpoints;
  }
  /**
   * List of resource files included in the API proxy revision.
   *
   * @param GoogleCloudApigeeV1ResourceFiles $resourceFiles
   */
  public function setResourceFiles(GoogleCloudApigeeV1ResourceFiles $resourceFiles)
  {
    $this->resourceFiles = $resourceFiles;
  }
  /**
   * @return GoogleCloudApigeeV1ResourceFiles
   */
  public function getResourceFiles()
  {
    return $this->resourceFiles;
  }
  /**
   * List of the resources included in the API proxy revision formatted as
   * "{type}://{name}".
   *
   * @param string[] $resources
   */
  public function setResources($resources)
  {
    $this->resources = $resources;
  }
  /**
   * @return string[]
   */
  public function getResources()
  {
    return $this->resources;
  }
  /**
   * API proxy revision.
   *
   * @param string $revision
   */
  public function setRevision($revision)
  {
    $this->revision = $revision;
  }
  /**
   * @return string
   */
  public function getRevision()
  {
    return $this->revision;
  }
  /**
   * List of the shared flows included in the API proxy revision.
   *
   * @param string[] $sharedFlows
   */
  public function setSharedFlows($sharedFlows)
  {
    $this->sharedFlows = $sharedFlows;
  }
  /**
   * @return string[]
   */
  public function getSharedFlows()
  {
    return $this->sharedFlows;
  }
  /**
   * OpenAPI Specification that is associated with the API proxy. The value is
   * set to a URL or to a path in the specification store.
   *
   * @param string $spec
   */
  public function setSpec($spec)
  {
    $this->spec = $spec;
  }
  /**
   * @return string
   */
  public function getSpec()
  {
    return $this->spec;
  }
  /**
   * List of TargetEndpoints in the `/targets` directory of the API proxy.
   * Typically, this element is included only when the API proxy was created
   * using the Edge UI. This is a 'manifest' setting designed to provide
   * visibility into the contents of the API proxy.
   *
   * @param string[] $targetEndpoints
   */
  public function setTargetEndpoints($targetEndpoints)
  {
    $this->targetEndpoints = $targetEndpoints;
  }
  /**
   * @return string[]
   */
  public function getTargetEndpoints()
  {
    return $this->targetEndpoints;
  }
  /**
   * List of TargetServers referenced in any TargetEndpoint in the API proxy.
   * Typically, you will see this element only when the API proxy was created
   * using the Edge UI. This is a 'manifest' setting designed to provide
   * visibility into the contents of the API proxy.
   *
   * @param string[] $targetServers
   */
  public function setTargetServers($targetServers)
  {
    $this->targetServers = $targetServers;
  }
  /**
   * @return string[]
   */
  public function getTargetServers()
  {
    return $this->targetServers;
  }
  /**
   * List of the targets included in the API proxy revision.
   *
   * @param string[] $targets
   */
  public function setTargets($targets)
  {
    $this->targets = $targets;
  }
  /**
   * @return string[]
   */
  public function getTargets()
  {
    return $this->targets;
  }
  /**
   * List of the teams included in the API proxy revision.
   *
   * @param string[] $teams
   */
  public function setTeams($teams)
  {
    $this->teams = $teams;
  }
  /**
   * @return string[]
   */
  public function getTeams()
  {
    return $this->teams;
  }
  /**
   * Type. Set to `Application`. Maintained for compatibility with the Apigee
   * Edge API.
   *
   * @param string $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApigeeV1ApiProxyRevision::class, 'Google_Service_Apigee_GoogleCloudApigeeV1ApiProxyRevision');
