<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AnalyticsHub;

class ExpirationPolicy extends \Google\Model
{
  /**
   * Optional. Specifies the "time-to-live" duration for an associated resource.
   * The resource expires if it is not active for a period of `ttl`. The
   * definition of "activity" depends on the type of the associated resource.
   * The minimum and maximum allowed values for `ttl` depend on the type of the
   * associated resource, as well. If `ttl` is not set, the associated resource
   * never expires.
   *
   * @var string
   */
  public $ttl;

  /**
   * Optional. Specifies the "time-to-live" duration for an associated resource.
   * The resource expires if it is not active for a period of `ttl`. The
   * definition of "activity" depends on the type of the associated resource.
   * The minimum and maximum allowed values for `ttl` depend on the type of the
   * associated resource, as well. If `ttl` is not set, the associated resource
   * never expires.
   *
   * @param string $ttl
   */
  public function setTtl($ttl)
  {
    $this->ttl = $ttl;
  }
  /**
   * @return string
   */
  public function getTtl()
  {
    return $this->ttl;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ExpirationPolicy::class, 'Google_Service_AnalyticsHub_ExpirationPolicy');
